clear all
clc

% DATI PROVENIENTI DALL'EXCEL:
N_pax=205;           % Numero passeggeri
W_TO=213152;         % [Kg] (205 Pax: 213152) (150 Pax: 204716) (180 Pax: 208849)
R_tot=6480;          % [Km]
T_TO=697000;         % [N]
MTOW=311;            % [t]
m_fuel=28252;        % [kg] (205 Pax: 28252) (150 Pax: 26416) (180 Pax: 26949)
m_cherosene=0;       % [kg]


% I valori che si calcolano sono in $/nm. 




% __________________________________________DIRECT OPERATING COST OF FLYING___________________________

% C_crew= Sum [n_cj*((1+Kj)/V_bl)*(SAL_j/AH_j)+(TEF_j/V_bl)]        Formula: Costo crew [USD/nm]

n_c1=1;                                         % N°1 Capitano
n_c2=2;                                         % N°2 First Officers

K=0.26;                                         % Fattore che riassume vari parametri come giorni di vacanza, addestramento...

t_gm1=(0.51*10^(-6)*W_TO*2.2)+0.125;            % Tempo a terra prima del take off [hr] (PAGINA 97)
t_cl=((200/1.852)/250);                         % Tempo di salita [hr]
t_cruise=((6080/1.852)/(250*1.944));            % Tempo di crocera [hr]
t_de=t_cl;                                      % Tempo discesa [hr]
t_gm2=t_gm1;                                    % Tempo a terra dopo il landing [hr]
t_bl=t_gm1+t_cl+t_cruise+t_de+t_gm2;            % Tempo complessivo missione [hr]
R_bl=R_tot/1.852;                               % Range complessivo missione [nm]
V_bl=R_bl/t_bl;                                 % Velocità dell'intera missione "block" [kn]

CPI_89=124.0;                                   % Consumer price index 1990
% CPI_22=292.66;                                % Consumer price index 2022
% CEF_22=CPI_22/CPI_89;                         % Cost escaltaion factor fino al 2022
% CEF=CEF_22;                                   % Cost escalation factor        <- Correggere, interpolazione con dati sito web
% for i=1:13                                    % 13 sono gli anni tra il 2022 e il 2035
%     CEF=CEF+(CEF*0.02);                       % Cost escalation factor nel 2035
% end
CPI_2035=324.37;                                % Ottenuto con l'interpolazione linerare vedi file excel
CEF=CPI_2035/CPI_89;                            % Cost escalation factor nel 2035
CEF_89=1;                                       % Cost escalation factor del 1989 (GRAFICO PAGINA 46)
Sal_cap89=35000;                                % Salario annuo capitano nel 1989 [USD]
Sal_FO89=30000;                                 % Salario annuo primo ufficiale nel 1989 [USD]
Sal_cap=Sal_cap89*(CEF/CEF_89);                 % Salario annuo capitano nel 2023 [USD]
Sal_FO=Sal_FO89*(CEF/CEF_89);                   % Salario annuo primo ufficiale nel 2023 [USD]

AH=750;                                         % Ore di volo per anno [hr]

TEF_90=10;                                      % Travel expense factor nel 1990: costi di pernottamento crew per ora [USD/blhr]
TEF=TEF_90*(CEF/CEF_89);                        % Travel expense factor nel 2035: costi di pernottamento crew per ora [USD/blhr]

C_cap=(n_c1*((1+K)/V_bl)*(Sal_cap/AH))+(TEF/V_bl);      % Costo capitano [USD/nm]  
C_FOs=(n_c2*((1+K)/V_bl)*(Sal_FO/AH))+(TEF/V_bl);       % Costo due primo ufficiale [USD/nm]
C_crew=C_cap+C_FOs;                                     % Costo crew [USD/nm]


% C_pol=1.05*[(WF_bl/R_bl)*(FP/FD)]     Formula: Costo lubrificanti e olii [USD/nm]

WF_bl=m_fuel*2.205;                                       % Block fuel in libbre [lb] (WF_bl=(1-0.8961)*(W_TO*2.2) (Roskam)) (<- Corretto)

H2_EuroKg = 2.5;                                          % Costo idrogeno liquido nel 2035 [Euro/kg]
H2_UsdKg = 2.62;                                          % Costo idrogeno liquido nel 2035 [USD/kg] 2.62
Conv_LitroKg = 1/0.07;                                    % Conversione da kg a litri [L]
H2_UsdLitro = H2_UsdKg / Conv_LitroKg;                    % Costo idrogeno liquido [USD/Litro]
Conv_LitroGallone = 0.26417;                              % Conversione da liro a gallone [Gallone]
FP = H2_UsdLitro / Conv_LitroGallone;                     % Costo idrogeno liquido [USD/Gallone]

FD=0.584178;                                            % Densità idrogeno liquido [Libbre/Gallone]

Wol_bl=0.70*2*t_bl;                                     % Peso olio e lubrificanti (NON NECESSARIO)

C_pol=1.05*((WF_bl/R_bl)*(FP/FD));                      % Costo lubrificante e olio nel 2035 [USD/nm]
%C_pol_K=1.05*((WF_bl/R_bl)*(FP/6.74));                  % Esempio: se usassimo il cherosene [USD/nm]

%C_ins=(fins_hull*AMP)/(Uann_bl*V_bl)       Formula: Costo assicurazione [USD/nm]

fins_hull=0.005;                            % Tasso di assicurazione annuo per lo scafo [USD/USD/airplane/Y], (Valore precedente 0.0175)

AMP=366000000;                              % Airplane market price A35k [USD]

Uann_bl=(10^3)*(3.4546*t_bl+2.994-(12.289*(t_bl)^2-5.6626*t_bl+8.964)^(1/2));     % Annual block hour utilization [hr] (PAGINA 102)

C_ins=((fins_hull*AMP)/(Uann_bl*V_bl))*(CEF/CEF_89);       % Costo assicurazione 2035 [USD/nm]

DOC_flt=C_crew+C_pol+C_ins;                 % Costo complessivo flt [USD/nm]


%__________________________________ DIRECT OPERATING COST OF MAINTENANCE_______________________________________

% C_lab_ap= 1.03*(MHR_map_bl*Rl_ap)/V_bl  Formula: Costo manutenzione airframe e sistemi [USD/nm]
t_flt=t_cl+t_cruise+t_de;                   % tempo di flight, no ground [hr]
MHR_map_flt=14.5*0.5;                       % Ore di lavoro per ora di volo flt solo per airframe e sistemi [hr] (PAGINA 120)
MHR_map_bl=MHR_map_flt*(t_flt/t_bl);        % Ore di lavoro per ora di missione complessiva per airframe e sistemi [hr]
Rl_ap89=10;                                 % Tariffa della manodopera per ora di lavoro nel 1989 [USD/hr] (PAGINA 111)
Rl_ap=Rl_ap89*(CEF/CEF_89);                 % Tariffa della manodopera per ora di lavoro nel 2035 [USD/hr]
C_lab_ap=1.03*MHR_map_bl*Rl_ap/V_bl;        % Costo manutenzione airframe e sistemi [USD/nm]


% C_lab_eng=1.03*1.3*2*(MHR_meng_bl*Rl_eng)/V_bl     Formula: Costo manutenzione motori [USD/nm]
MHR_meng_flt=14.5*0.5;                                              % Ore di lavoro per ora di volo flt solo per motore [hr] 
H_em=4000;                                                          % Ore tra una revisione del motore e la successiba [hr] (Si potrebbe mettere anche un valore più grande, 10000hr)
N_e=2;                                                              % Numero motori a bordo
MHR_meng_bl=0.10+((1100/H_em)*(0.718+(0.0317*((T_TO/N_e)/1000))));  % Ore di lavoro per ora di missione solo per motore [hr] (PAGINA 122), formula precedente (MHR_meng_bl=MHR_meng_flt*(t_flt/t_bl)) 
Rl_eng=Rl_ap;                                                       % Tariffa della manodopera per ora di lavoro 2035 [USD/hr]
C_lab_eng=1.03*1.3*2*MHR_meng_bl*Rl_eng/V_bl;                       % Costo manutenzione motori [USD/nm]


% C_mat_ap=1.03*C_mat_apblhr/V_bl           Formula: Costo manutenzione materiali airframe [USD/nm]
C_mat_apblhr_89=400;                            % Costo manutenzione materiali airframe per ora di volo missione nel 1989 [USD/hr] (PAGINA 125), valore precedente 500 (<- Corretto)
C_mat_apblhr=C_mat_apblhr_89*(CEF/CEF_89);      % Costo manutenzione materiali airframe per ora di volo missione nel 2035 [USD/hr]
C_mat_ap=1.03*C_mat_apblhr/V_bl;                % Costo manutenzione materiali airframe [USD/nm]


% C_mat_eng=1.03*1.3*2*C_mat_engblhr/V_bl   Formula: Costo manutenzione materiali per i motori [USD/nm]
H_em=4000;                                                  % Ore tra una revisione del motore e la successiba [hr] (Si potrebbe mettere anche un valore più grande, 10000hr)
EP=20000000;                                                % Engine price, prezzo motore [USD]
ESPPF=1.5;                                                  % Fattore di costo parti di ricambio motore  
K_hem=(0.021*(H_em/100)+0.769);                             % Fattore ore tra una revisione del motore e la successiva (PAGINA 128)
C_mat_engblhr_89=((5.43*10^(-5)*EP)*(ESPPF)-0.47)/K_hem;    % Costo manutenzione materiali motore per ora di missione nel 1989 [USD/hr] (PAGINA 126), valore precendete 1389 (<- Corretto)
C_mat_engblhr=C_mat_engblhr_89*(CEF/CEF_89);                % Costo manutenzione materiali motore per ora di missione nel 2035 [USD/hr] 
C_mat_eng=1.03*1.3*2*C_mat_engblhr/V_bl;                    % Costo manutenzione materiali per i motori [USD/nm]


% C_amb=1.03*[f_amb_lab*{MHR_map_bl*Rl_ap + 2*MHR_eng_bl*Rl_eng} + ...
% f_amb_mat*{C_mat_apblhr + 2*C_mat_engblhr}]/V_bl  Formula: Costi vari come l'elettricità, riscaldamento, affitto locali [USD/nm]
f_amb_lab=1.2;      % Fattore di distribuzione per il costo del lavoro (PAGINA 128)
f_amb_mat=0.55;     % Fattore di distribuzione per il costo dei materiali (PAGINA 128)
C_amb=1.03*(f_amb_lab*((MHR_map_bl*Rl_ap) + (2*MHR_meng_bl*Rl_eng)) + f_amb_mat*((C_mat_apblhr) + (2*C_mat_engblhr)))/V_bl; % Costo [USD/nm]

DOC_maint=C_lab_ap+C_lab_eng+C_mat_ap+C_mat_eng+C_amb;      % Costo complessivo manutenzione [USD/nm]


% __________________________________DIRECT OPERATING COST OF DEPRECIATION______________________________________

% C_dap=(F_dap*(AEP - N_e*EP - ASP))/(DP_ap*U_ann_bl*V_bl) Formula: Deprezzamento del solo aereo [USD/nm]
F_dap=0.85;             % Fattore di deprezzamento airframe
AEP=366000000;          % Airplane estimated price [USD]
N_e=2;                  % Numero motori a bordo
EP=20000000;            % Engine price, prezzo motore [USD]
ASP=366000000*0.28;     % Avion system price, costo avionica [USD]
DP_ap=10;               % Periodo di deprezzamento del velivolo [YY]
C_dap=(F_dap*(AEP-(N_e*EP)-ASP))/(DP_ap*Uann_bl*V_bl);  % Deprezzamento del solo aereo [USD/nm]

% C_deng=(F_deng*N_e*EP)/(DP_eng*Uann_bl*V_bl) Formula: Deprezzamento motore [USD/nm]
F_deng=0.85;                                    % Fattore di deprezzamento motore (PAGINA 133)
DP_eng=7;                                       % Periodo di deprezzamento motore [YY]
C_deng=(F_deng*N_e*EP)/(DP_eng*Uann_bl*V_bl);   % Deprezzamento motore [USD/nm]

% C_dav=(F_dav*ASP)/(DP_av*Uann_bl*V_bl)    Forumla: Deprezzamento Avionica
F_dav=1;                                        % Fattore di deprezzamento avionica
DP_av=5;                                        % Periodo di deprezzamento avionica [YY]
C_dav=(F_dav*ASP)/(DP_av*Uann_bl*V_bl);         % Deprezzamento avionica [USD/nm]

% C_dapsp=((F_dapsp*F_apsp)*(AEP-(N_e*EP)))/(DP_apsp*Uann_bl*V_bl) Formula: Deprezzamento parti di ricambio aereo [USD/nm]
F_dapsp=0.85;                                   % Fattore di deprezzamento dei componenti di ricambio per il velivolo
DP_apsp=10;                                     % Periodo di deprezzamento dei componenti di ricambio per il velivolo
F_apsp=0.10;                                    % Fattore delle parti di ricambio del velivolo
C_dapsp=((F_dapsp*F_apsp)*(AEP-(N_e*EP)))/(DP_apsp*Uann_bl*V_bl);   % Deprezzamento parti di ricambio aereo [USD/nm]

% C_dengsp=(F_dengsp*F_engsp*N_e*EP*ESPPF)/(DP_engsp*Uann_bl*V_bl)  Deprezzamento parti di ricambio del motore [USD/nm]
F_dengsp=0.85;                                  % Fattore di deprezzamento dei compoenti di ricambio per il motore
DP_engsp=7;                                     % Periodo di deprezzamento dei componenti di ricambio per il motore
F_engsp=0.5;                                    % Fattore delle parti di ricambio del motore
ESPPF=1.5;                                      % Fattore di costo parti di ricambio motore
C_dengsp=(F_dengsp*F_engsp*N_e*EP*ESPPF)/(DP_engsp*Uann_bl*V_bl); % Deprezzamento parti di ricambio del motore [USD/nm]

DOC_depr=C_dap+C_deng+C_dav+C_dapsp+C_dengsp;   % Costo complessivo del deprezzamento [USD/nm]


% ______________________DIRECT OPERATING COST OF LANDING FEES, NAVIGATION FEES AND TAXES____________________________

% Ipotizziamo un volo lungo 6480 km da Francoforte a Washigton Dulles

% C_lf=C_aplf/(V_bl*t_bl)   Formula: Tasse per l'atterraggio [USD/nm] ROSKAM
%C_aplf=0.002*W_TO*2.2;      % Tassa di atterraggio per atterraggio [USD/lb] (Formula modello di Roskam)
%C_lf=C_aplf/(V_bl*t_bl);    % Tassa per l'atterraggio [USD/nm] (Formula modello di Roskam)

% C_nf=C_apnf/(V_bl*t_bl)   Formula: Tassa per la navigazione [USD/nm] ROSKAM
% C_apnf=10;                  % Tassa sulla navigazione per aereo e per volo [USD/flight] (Formula modello di Roskam)
% C_nf=C_apnf/(V_bl*t_bl);    % Tassa sulla navigazione [USD/nm] (Formula modello di Roskam)

ln_fee=5*N_pax;                                           % Tassa per l'atterraggio [USD/flt]                       
C_lf=ln_fee/R_bl;                                       % Tassa per l'atterraggio [USD/nm]


weight_factor=sqrt(MTOW/50);                             % Fattore di peso [t]

Distance_DE=196;                                         % Distanza percorsa in Germania [km]
Dis_factor_DE=Distance_DE/100;
Unite_rate_DE=76.95;                                     % Tasso unitario in Germania [USD]
charge_DE=Dis_factor_DE*weight_factor*Unite_rate_DE;     % Tassa di navigazione in Germania [USD/flt]

Distance_BE=238;                                         % Distanza percorsa in Belgio [km]
Dis_factor_BE=Distance_BE/100;
Unite_rate_BE=113.21;                                    % Tasso unitario in Belgio [USD]
charge_BE=Dis_factor_BE*weight_factor*Unite_rate_BE;     % Tassa di navigazione in Belgio [USD/flt]

Distance_UK=587;                                         % Distanza percorsa in UK [km]
Dis_factor_UK=Distance_UK/100;
Unite_rate_UK=90.22;                                     % Tasso unitario in UK [USD]
charge_UK=Dis_factor_UK*weight_factor*Unite_rate_UK;     % % Tassa di navigazione in UK [USD/flt]

Distance_IR=352;                                         % Distanza percorsa in Irlanda [km]
Dis_factor_IR=Distance_IR/100;
Unite_rate_IR=27.88;                                     % Tasso unitario in Irlanda [USD]
charge_IR=Dis_factor_IR*weight_factor*Unite_rate_IR;     % Tassa di navigazione in Irlanda [USD/flt]

Distance_AT=2981;                                        % Distanza percorsa sull'oceano Atlantico [km]
Fee_AT=71.60;                                            % Tassa per il sorvolo dell'oceano Atlantico [USD/flt]

Distance_CA=1127;                                        % Distanza percorsa in Canada [km]
Dis_factor_CA=Distance_CA/100;
Unite_rate_CA=0.03263;                                   % Tasso unitario in Canada [USD]
charge_CA=Dis_factor_CA*weight_factor*Unite_rate_CA;     % Tassa di navigazione in Canada [USD/flt]

Distance_US=1050;                                        % Distanza percorsa negli Stati Uniti [km]
US_navfee=0;                                             % Tassa di navigazione negli Stati Uniti [USD/flt]

Nav_fee=charge_DE+charge_BE+charge_UK+charge_IR+Fee_AT+charge_CA+US_navfee;  % Tassa di navigazione complessiva [USD/flt]
C_nf=Nav_fee/(6526/1.852);                                                   % Tassa di navigazione complessiva [USD/nm]


Basic_terminal_fee=290.68;                               % Costo base terminal Francoforte [USD/flt]
Variable_terminal_fee=321.02;                            % Costo variabile terminal Francorforte [USD/flt]
C_term=Basic_terminal_fee+Variable_terminal_fee;         % Terminal Charge dal PDF di Francoforte Airport [USD/flt]
C_term_mn=C_term/R_bl;                                   % Terminal Charge [USD/nm]


% Emissioni di CO2 - Solo Cherosene!
e_CO2=(m_cherosene*3.15)/1000;              % Emissioni di CO2 [g]
ct_co2=26.25;                               % Costo emission certificate [USD/ton]
n_y=2019;                                   % Anno di riferimento [YY]
p_co2_free=82;                              % Percentuale certificati gratuiti 
CETS=(3.15*10^(-3)*m_cherosene*ct_co2*(17.6+0.7*(n_y-2010))*(1-(p_co2_free)/(100+2.5*(n_y-2005))))/(64.4+3.1*(n_y-2010));    % Tassa emissione di CO2 [USD/flt]
C_co2_fee=CETS/R_bl;                        % Tassa emissione di CO2 [USD/nm]

% Emissioni di NOx
e_NOx=33540*0.3;                                % Emissioni di NOx nel ciclo LTO [g]
e_HC=5*0.3;                                     % Emissioni di HC nel ciclo LTO [g]
Cp=7.12*10^(-4)*e_NOx*N_e;                      % CO2 emition charges [Eur]
C_nox_fee=(Cp/R_bl);                            % CO2 emition charges [Eur/nm]

DOC_lnr=C_lf+C_nf+C_term_mn+C_nox_fee;          % Costo complessivo tasse [USD/nm]


% _________________________________________SOMMA TOTALE COSTI DIRETTI e INDIRETTI__________________________________________

DOC=DOC_flt+DOC_maint+DOC_depr+DOC_lnr;     % Costo operativo diretto [$/nm]
DOC_hr=DOC*390;                             % Costo operativo diretto [$/blhr]

f_ioc=0.50;                                 % Parametro per calcolo costi indiretti
IOC=f_ioc*DOC;                              % Costo operativo indiretto [USD/nm]
IOC_hr=IOC*390;                             % Costo operativo indiretto [USD/blhr]

tot_mn=DOC+IOC;                             % Costo totale [USD/nm]
tot_hr=DOC_hr+IOC_hr;                       % Costo totale [USD/blhr]


